<?php
/**
 * pdpguyana functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package pdpguyana
 */

if ( ! function_exists( 'pdpguyana_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function pdpguyana_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on pdpguyana, use a find and replace
		 * to change 'pdpguyana' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'pdpguyana', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'menu-1' => esc_html__( 'Primary', 'pdpguyana' ),
			'menu-2' => esc_html__( 'Footer', 'pdpguyana' ),
			'menu-3' => esc_html__( 'Language', 'pdpguyana' ),
		) );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'pdpguyana_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		) );
	}
endif;
add_action( 'after_setup_theme', 'pdpguyana_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function pdpguyana_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'pdpguyana_content_width', 640 );
}
add_action( 'after_setup_theme', 'pdpguyana_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function pdpguyana_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'pdpguyana' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'pdpguyana' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar(
	array(
	'name'          => 'Column 1',
	'id'            => 'footer1',
	'description'   => 'Footer Column 1'

	));

	register_sidebar(
	array(
	'name'          => 'Column 2',
	'id'            => 'footer2',
	'description'   => 'Footer Column 2'

	));

	register_sidebar(
	array(
	'name'          => 'Column 3',
	'id'            => 'footer3',
	'description'   => 'Footer Column 3'

	));
}
add_action( 'widgets_init', 'pdpguyana_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function pdpguyana_scripts() {
	
	wp_enqueue_style( 'pdpguyana-style', get_stylesheet_uri() );

	wp_enqueue_style( 'wpb-google-fonts', 'https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i,800,800i', false ); 

	wp_enqueue_style( 'thinkhugewp-navigation', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.11.2/css/all.css');

	wp_enqueue_script( 'pdpguyana-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true );

	wp_enqueue_script( 'pdpguyana-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true );

	//wp_enqueue_script( 'pdpguyana-skip-link-focus-fix-two', get_template_directory_uri() . '/js/ticker.js', array(), '20151215', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'pdpguyana_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

function wpb_add_google_fonts() {
 
	wp_enqueue_style( 'wpb-google-fonts', 'http://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,700italic,400,700,300', false ); 
	}
	 
	add_action( 'wp_enqueue_scripts', 'wpb_add_google_fonts' );

function wpb_add_google_fontsa() {

wp_enqueue_style( 'wpb-google-fontsa', 'https://fonts.googleapis.com/css?family=Montserrat:800', false ); 
}

add_action( 'wp_enqueue_scripts', 'wpb_add_google_fontsa' );

/**
 * Generate breadcrumbs
 */
/*function get_breadcrumb() {
	echo '<a href="'.home_url().'" rel="nofollow">Home</a>';
	if (is_category() || is_single()) {
			echo "&nbsp;&nbsp;&#8725;&nbsp;&nbsp;";
			the_category(' &bull; ');
					if (is_single()) {
							echo " &nbsp;&nbsp;&#8725;&nbsp;&nbsp; ";
							the_title();
					}
	} elseif (is_page()) {
			echo "&nbsp;&nbsp;&#8725;&nbsp;&nbsp;";
			echo the_title();
	} elseif (is_search()) {
			echo "&nbsp;&nbsp;&#8725;&nbsp;&nbsp;Search Results for... ";
			echo '"<em>';
			echo the_search_query();
			echo '</em>"';
	}
}*/

/* For fixing upload error for images */
function wpb_image_editor_default_to_gd( $editors ) {
	$gd_editor = 'WP_Image_Editor_GD';
	$editors = array_diff( $editors, array( $gd_editor ) );
	array_unshift( $editors, $gd_editor );
	return $editors;
}
add_filter( 'wp_image_editors', 'wpb_image_editor_default_to_gd' );

/* WooCommerce Support */
/*
function mytheme_add_woocommerce_support() {
	add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'mytheme_add_woocommerce_support' );*/

function mytheme_add_woocommerce_support() {
	add_theme_support( 'woocommerce', array(
		'thumbnail_image_width' => 150,
		'single_image_width'    => 300,

        'product_grid'          => array(
            'default_rows'    => 3,
            'min_rows'        => 2,
            'max_rows'        => 8,
            'default_columns' => 4,
            'min_columns'     => 2,
            'max_columns'     => 5,
        ),
	) );
}
add_action( 'after_setup_theme', 'mytheme_add_woocommerce_support' );

add_action('template_redirect', 'remove_shop_breadcrumbs' );

function remove_shop_breadcrumbs(){
        remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
}

/**
 * Remove related products output
 */
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );

/* remove placeholder image */
//remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20 );
// Add Favicon with WordPress Hook 

add_action( 'wp_head', 'ilc_favicon');
function ilc_favicon(){
    echo "<link rel='shortcut icon' href='" . get_stylesheet_directory_uri() . "/favicon.ico' />" . "\n";
}