<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package pdpguyana
 */

?>

<!doctype html>
<html <?php language_attributes(); ?>>
<head>

	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>

</head>

<body <?php body_class(); ?> >

<div class="container"> <!--- starts css grid -->


<header>



	<div id="news-container">
					<div id="news-centered">
						<?php echo do_shortcode('[jquery-news-ticker group="GROUP1" title="News" direction="ltr" type="fade" pause="4000"]'); ?>
					</div>
					<div id="social-news-links">
						<a href="http://twitter.com/FidelityPAC">
						<svg style="width:18px;height:18px" viewBox="0 0 24 24">
						<path fill="currentColor" d="M22.46,6C21.69,6.35 20.86,6.58 20,6.69C20.88,6.16 21.56,5.32 21.88,4.31C21.05,4.81 20.13,5.16 19.16,5.36C18.37,4.5 17.26,4 16,4C13.65,4 11.73,5.92 11.73,8.29C11.73,8.63 11.77,8.96 11.84,9.27C8.28,9.09 5.11,7.38 3,4.79C2.63,5.42 2.42,6.16 2.42,6.94C2.42,8.43 3.17,9.75 4.33,10.5C3.62,10.5 2.96,10.3 2.38,10C2.38,10 2.38,10 2.38,10.03C2.38,12.11 3.86,13.85 5.82,14.24C5.46,14.34 5.08,14.39 4.69,14.39C4.42,14.39 4.15,14.36 3.89,14.31C4.43,16 6,17.26 7.89,17.29C6.43,18.45 4.58,19.13 2.56,19.13C2.22,19.13 1.88,19.11 1.54,19.07C3.44,20.29 5.7,21 8.12,21C16,21 20.33,14.46 20.33,8.79C20.33,8.6 20.33,8.42 20.32,8.23C21.16,7.63 21.88,6.87 22.46,6Z" />
						</svg></a>
						<a href="https://www.linkedin.com/company/fidelity-pac-metals-ltd/">
						<svg style="width:18px;height:18px" viewBox="0 0 24 24">
						<path fill="currentColor" d="M19 3A2 2 0 0 1 21 5V19A2 2 0 0 1 19 21H5A2 2 0 0 1 3 19V5A2 2 0 0 1 5 3H19M18.5 18.5V13.2A3.26 3.26 0 0 0 15.24 9.94C14.39 9.94 13.4 10.46 12.92 11.24V10.13H10.13V18.5H12.92V13.57C12.92 12.8 13.54 12.17 14.31 12.17A1.4 1.4 0 0 1 15.71 13.57V18.5H18.5M6.88 8.56A1.68 1.68 0 0 0 8.56 6.88C8.56 5.95 7.81 5.19 6.88 5.19A1.69 1.69 0 0 0 5.19 6.88C5.19 7.81 5.95 8.56 6.88 8.56M8.27 18.5V10.13H5.5V18.5H8.27Z" />
						</svg>
						</a>
					</div>


		</div>


		<div id="logo-social-container">
		<div id="menu-button"> 
			<a class="toggle open" href="#site-navigation"> &#9776;</a>
		</div>
		<div id="logo">
			<?php
				if ( function_exists( 'the_custom_logo' ) ) {
					the_custom_logo();
				}
			?>
		</div>

		<div id="contact-social">
				<a href="https://new.fidelitypac.ca/english/"><img src="https://new.fidelitypac.ca/french/wp-content/themes/thinkhuge-wp/images/en-website-link.jpg"></a>
		</div>

		<div id="main-menu-container">	

				<div id="main-menu">
						<div id="main-menu-bg">
							<nav id="site-navigation" class="main-navigation">
								<a class="toggle close" href="#"></a>
								<?php
								wp_nav_menu( array(
								'theme_location' => 'menu-1',
								'menu_id'        => 'primary-menu',
								) );
								?>
							</nav>
						</div>
				</div>
				

		</div>	
		

	<?php 
	//Shows Slides on HomePage
	if  ( is_page(504) ) {
		echo "<div id='home-img'>";
		layerslider(5);
		echo "</div>";
	}
		//If Nothing is triggered this shows by default
		else {
			echo '<div class="breadcrumb"><span>';
						//get_breadcrumb();
						if ( function_exists('yoast_breadcrumb') ) {
							yoast_breadcrumb( '<p id="breadcrumbs">','</p>' );
						};
			echo '</span></div>';
	  }
	?>




<?php

		$host = $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
		if($host == 'fidelitypac.ca/surcharges/new_website_nikel_prices.php') {
			//echo ('we on nickel price page boys');
		}
		else
		{
			//echo ('Not on nickel prices');
		}

?>	

</header><!-- #masthead -->