<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package pdpguyana
 */

?>


<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> >
	
<div class="press-img"><?php the_post_thumbnail('medium'); ?></div>

<div class="press-title-content">	
		<p><time><?php echo get_the_date() ?></time></p>
		<?php the_title( '<h2><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); ?>
		
		<?php
		the_content( sprintf(
			wp_kses(
				/* translators: %s: Name of current post. Only visible to screen readers */
				__( 'Lire la suite', 'pdpguyana' ),
				array(
					'span' => array(
						'class' => array(),
					),
				)
			),
			get_the_title()
		) );

		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'pdpguyana' ),
			'after'  => '</div>',
		) );
		?>

</div>
<div class="press-date"><time><?php //echo get_the_date() ?></time></div>
</article><!-- #post-<?php the_ID(); ?> -->