<?php

/*
Plugin Name: Think Huge Help Menu
Version: 0.9
Plugin URI: https://www.think-huge.com
Description: Adds a "Help" Menu and Page in admin with links to Wordpress resources.
Author: Jeff Weales
Author URI: http://www.weales.com
*/

// think_help_add_pages() is the function for the 'admin_menu' hook
function think_help_add_pages() {
    
    //Add a new top-level menu
    add_menu_page('Wordpress Help', 'Video Tutorials','5','help', 'think_help_toplevel_page', plugins_url('images/help.png', __FILE__), 1 );
    add_submenu_page('help', 'Dashboard', 'Dashboard','5','dashboard','think_help_submenu_page_dashboard' );
    add_submenu_page('help', 'Home Page', 'Home Page','5', 'homepage','think_help_submenu_page_homepage' );
    add_submenu_page('help', 'Product Page', 'Product Page','5', 'productpage','think_help_submenu_page_productpage' );
    add_submenu_page('help', 'Specifications, Online Tools & Careers', 'Specifications, Online Tools & Careers','5', 'specpage','think_help_submenu_page_specpage' );
    add_submenu_page('help', 'Backup Website & Update Plugins','Backup Website & Update Plugins', '5', 'update','think_help_submenu_page_backups' );
}

// think_help_toplevel_page() displays the page content for the Toplevel menu
function think_help_toplevel_page() {

    echo "<div class='wrap'>";
    echo "<div id='welcome-panel' class='welcome-panel'>";
    echo '<img src="' . plugins_url( 'images/logo-fidelity2-300x103.png', __FILE__ ) . '" >';
    echo "<p>Click on the videos and watch each video for the corresponding part of the website you wish to review.</p>
    </div>";
    echo "</div>";
}

// Displays the submenu content
function think_help_submenu_page_dashboard() {
    
    echo "<div class='wrap'><div id='welcome-panel' class='welcome-panel'>";
    echo"<h1>Dashboard Overview</h1>";
    echo "&nbsp;";
    echo "<iframe width='960' height='720' src='https://www.youtube.com/embed/zACYFln8hV8?rel=0&amp;showinfo=0' frameborder='0' allow='autoplay; encrypted-media' allowfullscreen></iframe>";
    echo"</div></div>";

}

// Displays the submenu content
function think_help_submenu_page_homepage() {
    
    echo "<div class='wrap'><div id='welcome-panel' class='welcome-panel'>";
    echo"<h1>Home Page</h1>";
    echo "&nbsp;";
    echo "<iframe width='960' height='720' src='https://www.youtube.com/embed/Erl2lSoeWt8?rel=0&amp;showinfo=0' frameborder='0' allow='autoplay; encrypted-media' allowfullscreen></iframe>";
    echo"</div></div>";

}

// Displays the submenu content
function think_help_submenu_page_productpage() {
    
    echo "<div class='wrap'><div id='welcome-panel' class='welcome-panel'>";
    echo"<h1>Product Page</h1>";
    echo "&nbsp;";
    echo "<iframe width='960' height='720' src='https://www.youtube.com/embed/WYBGs6pDgtQ?rel=0&amp;showinfo=0' frameborder='0' allow='autoplay; encrypted-media' allowfullscreen></iframe>";
    echo"</div></div>";

}

// Displays the submenu content
function think_help_submenu_page_specpage() {
    
    echo "<div class='wrap'><div id='welcome-panel' class='welcome-panel'>";
    echo"<h1>Specifications, Online Tools & Careers Pages</h1>";
    echo "&nbsp;";
    echo "<iframe width='960' height='720' src='https://www.youtube.com/embed/62BMFgOYFFk?rel=0&amp;showinfo=0' frameborder='0' allow='autoplay; encrypted-media' allowfullscreen></iframe>";
    echo"</div></div>";

}

function think_help_submenu_page_backups() {

    echo "<div class='wrap'><div id='welcome-panel' class='welcome-panel'>";
    echo"<h1>Backup & Update Plugins</h1>";
    echo "&nbsp;";
    echo "<iframe width='960' height='720' src='https://www.youtube.com/embed/Nw5iaaFh2Vg?rel=0&amp;showinfo=0' frameborder='0' allow='autoplay; encrypted-media' allowfullscreen></iframe>";
    echo"</div></div>";

}


// Insert the think_help_add_pages() sink into the plugin hook list for 'admin_menu'
add_action('admin_menu', 'think_help_add_pages');
?>