<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package pdpguyana
 */

?>

<!doctype html>
<html <?php language_attributes(); ?>>
<head>

	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>

</head>

<body <?php body_class(); ?> >

<div class="container"> <!--- starts css grid -->


<header>
<a class="toggle open" href="#site-navigation"> &#9776;</a>


		<div id="news-container">
					<div id="news-centered">
					<?php echo do_shortcode('[jquery-news-ticker group="GROUP1" title="News" direction="ltr" type="fade" pause="4000"]'); ?>
					</div>
		</div>


		<div id="logo-social-container">
		
		<div id="logo">
			<?php
				if ( function_exists( 'the_custom_logo' ) ) {
					the_custom_logo();
				}
			?>
		</div>

		<div id="contact-social">
		<p>
		<a class="lang" href="#">FR</a>	
		<a href="http://www.fidelitypac.ca/contact/#skype"><i class="fab fa-skype"></i></a> <a href="http://twitter.com/FidelityPAC"><i class="fab fa-twitter"></i></a> 
		<span class="phone-number"><a href="tel:+1289-851-1076">+1 289 851-1076</a></span>
		</p>
		</div>
		</div>

		<div id="main-menu-container">	

				<div id="main-menu">
						<div id="main-menu-bg">
							<nav id="site-navigation" class="main-navigation">
								<a class="toggle close" href="#"></a>
								<?php
								wp_nav_menu( array(
								'theme_location' => 'menu-1',
								'menu_id'        => 'primary-menu',
								) );
								?>
							</nav>
						</div>
				</div>
				

		</div>	

		

	<?php 
	//Shows Slides on HomePage
	if  ( is_page(504) ) {
		echo "<div id='home-img'>";
		layerslider(5);
		echo "</div>";
	}
	elseif ( is_product_category() ) {
		echo '<div class="breadcrumb"><span>';
					//get_breadcrumb();
					if ( function_exists('yoast_breadcrumb') ) {
						yoast_breadcrumb( '<p id="breadcrumbs">','</p>' );
					};
		echo '</span></div>';
	} 
	//If the About Page has a feature image attached, it displays it here.
	elseif ( is_page( 14765 ) ) {
		$backgroundImg = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );
		echo "<div id='featured-img' style='background: url( $backgroundImg[0] ) no-repeat center center; height: 40vh; background-size: cover;'></div>";
		echo '<div class="breadcrumb"><span>';
					//get_breadcrumb();
					if ( function_exists('yoast_breadcrumb') ) {
						yoast_breadcrumb( '<p id="breadcrumbs">','</p>' );
					};
		echo '</span></div>';
		} 
		//If Nothing is triggered this shows by default
		else {
			echo '<div class="breadcrumb"><span>';
						//get_breadcrumb();
						if ( function_exists('yoast_breadcrumb') ) {
							yoast_breadcrumb( '<p id="breadcrumbs">','</p>' );
						};
			echo '</span></div>';
	  }
	?>




<?php

		$host = $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
		if($host == 'fidelitypac.ca/surcharges/new_website_nikel_prices.php') {
			//echo ('we on nickel price page boys');
		}
		else
		{
			//echo ('Not on nickel prices');
		}

?>	

</header><!-- #masthead -->